#define SHADOW

const float poissonSpreadBase 	= 3000.0;
const float poissonSpreadAdjustClose = 2.0;
const float poissonSpreadAdjustFar = 1.6;
const float poissonSpreadClose 	= poissonSpreadBase * (1.0 + (1.0-SHADOW_RES_MULTIPLIER_CLOSE) * poissonSpreadAdjustClose);
const float poissonSpreadFar 	= poissonSpreadBase * (1.0 + (1.0-SHADOW_RES_MULTIPLIER_FAR) * poissonSpreadAdjustFar);
const vec2 poissonDisk0 = vec2(-0.94201624, -0.39906216);
const vec2 poissonDisk1 = vec2( 0.94558609, -0.76890725);
const vec2 poissonDisk2 = vec2(-0.09418410, -0.92938870);
const vec2 poissonDisk3 = vec2( 0.34495938,  0.29387760);

const float biasAdjustMultiplier = 3.0;
#ifdef SHADOW_INCREASED_BIAS
const float biasMin = 	0.0005 * 1.5;
const float biasBase = 	0.001 * 3.0;
const float biasMax = 	0.01 * 3.0;
#else
const float biasMin = 	0.0005;
const float biasBase = 	0.001;
const float biasMax = 	0.01;
#endif

const float biasDotMin = 0.001;


float calcShadowSlopeBiasFactor(in vec3 normalDirection, in vec3 lightDirection)
{
	float value = clamp(dot(normalDirection, lightDirection), biasDotMin, 1.0);
	//return tan(acos(value));
	return sqrt(1.0-value*value)/value;
}

float calcShadowSlopeBiasFactorMesh(in vec3 normalDirection, in vec3 lightDirection)
{
	const float meshAdjust = 0.5;
	float value = clamp(dot(normalDirection, lightDirection) + meshAdjust, biasDotMin, 1.0);
	return sqrt(1.0-value*value)/value;
}

float getBiasClose(in float slopeBias)
{
	const float adjust = 1.0 + (1.0-SHADOW_RES_MULTIPLIER_CLOSE) * biasAdjustMultiplier;
	return biasMin + clamp(biasBase*adjust*slopeBias, 0.0, biasMax);
}

float getBiasFar(in float slopeBias)
{
	const float adjust = 1.0 + (1.0-SHADOW_RES_MULTIPLIER_FAR) * biasAdjustMultiplier;
	return biasMin + clamp(biasBase*adjust*slopeBias, 0.0, biasMax);
}

float getShadow(in vec2 poisson, in sampler2DShadow tex, in vec2 coord, in float ref)
{
	return shadow2D(tex, vec3(coord+poisson, ref)).r;
}

float getVisibility4Samples(in sampler2DShadow tex, in vec4 coord, in float slopeBias, in float poissonSpread)
{
	const float samples = 4.0;

	float shadowRef = (coord.z-slopeBias)/coord.w;
	float shadow = 0.0;

	shadow += getShadow(poissonDisk0/poissonSpread, tex, coord.xy, shadowRef);
	shadow += getShadow(poissonDisk1/poissonSpread, tex, coord.xy, shadowRef);
	shadow += getShadow(poissonDisk2/poissonSpread, tex, coord.xy, shadowRef);
	shadow += getShadow(poissonDisk3/poissonSpread, tex, coord.xy, shadowRef);

	return (1.0-SHADOW_DAYTIME_FACTOR) + SHADOW_DAYTIME_FACTOR * shadow/samples;
}

float getVisibility2Samples(in sampler2DShadow tex, in vec4 coord, in float slopeBias, in float poissonSpread)
{
	const float samples = 2.0;

	float shadowRef = (coord.z-slopeBias)/coord.w;
	float shadow = 0.0;

	shadow += getShadow(poissonDisk0/poissonSpread, tex, coord.xy, shadowRef);
	shadow += getShadow(poissonDisk1/poissonSpread, tex, coord.xy, shadowRef);

	return (1.0-SHADOW_DAYTIME_FACTOR) + SHADOW_DAYTIME_FACTOR * shadow/samples;
}

float getVisibility1Sample(in sampler2DShadow tex, in vec4 coord, in float slopeBias)
{
	float shadowRef = (coord.z-slopeBias)/coord.w;
	float shadow = shadow2D(tex, vec3(coord.xy, shadowRef)).r;

	return (1.0-SHADOW_DAYTIME_FACTOR) + SHADOW_DAYTIME_FACTOR * shadow;
}

float getVisibility(in int csmIndex, in sampler2DShadow texClose, in sampler2DShadow texFar, in vec4 coord, in float slopeBias)
{
	if(csmIndex == SHADOW_INDEX_CLOSE)
		return getVisibility4Samples(texClose, coord, getBiasClose(slopeBias), poissonSpreadClose);
	else
		return getVisibility1Sample(texFar, coord, getBiasFar(slopeBias));
}

float getVisibility(in int csmIndex, in sampler2DShadow texClose, in sampler2DShadow texFar, in vec4 coordClose, in vec4 coordFar, in float slopeBias, vec3 closeCenter, vec3 worldCoords)
{
	if(csmIndex == SHADOW_INDEX_CLOSE)
	{
		const float interpolRange = 0.05;
		const float interpolRangeDouble = 2.0*interpolRange;

		vec2 diff = worldCoords.xz-closeCenter.xz;
		float normCheby = max(abs(diff.x), abs(diff.y)) / (SHADOW_CLOSE_MAP_WIDTH*0.5);

		float interpolFactor = (normCheby - (1.0-interpolRangeDouble)) / interpolRangeDouble;
		interpolFactor = 1.0 - clamp(interpolFactor, 0.0, 1.0);

		const float heightInterpolInverseRange = 1.0;
		float heightDiff = worldCoords.y-closeCenter.y;
		float heightFactor = clamp(heightDiff*heightInterpolInverseRange, 0.0, 1.0);
		interpolFactor *= heightFactor;

		float visibilityClose = getVisibility4Samples(texClose, coordClose, getBiasClose(slopeBias), poissonSpreadClose);
		float visibilityFar = getVisibility2Samples(texFar, coordFar, getBiasFar(slopeBias), poissonSpreadFar);

		return mix(visibilityFar, visibilityClose, interpolFactor);
	}
	else
		return getVisibility1Sample(texFar, coordFar, getBiasFar(slopeBias));
}

vec4 getVisibilityVector(in float visibilityFactor)
{
	const vec4 shadowColor = vec4(50.0/256.0, 0.0/256.0, 100.0/256.0, 1.0);
	return mix(shadowColor, vec4(1.0), visibilityFactor);
}


